#include <stdio.h>
#include <vector>
#include <algorithm>

struct Node {
    int w; 
    int id;
    unsigned pr;
    Node *l, *r;
    int sz;
    int sum;
    Node(int _w, int _id, unsigned _pr)
        : w(_w), id(_id), pr(_pr), l(nullptr), r(nullptr), sz(1), sum(_w) {}
};

static unsigned rng_state = 123456789u;
static unsigned rng() {
    rng_state ^= rng_state << 13;
    rng_state ^= rng_state >> 17;
    rng_state ^= rng_state << 5;
    return rng_state;
}

static int getsz(Node* t){ return t ? t->sz : 0; }
static int getsum(Node* t){ return t ? t->sum : 0; }
static void pull(Node* t){
    if (!t) return;
    t->sz = 1 + getsz(t->l) + getsz(t->r);
    t->sum = t->w + getsum(t->l) + getsum(t->r);
}

static bool lessKey(int w1, int id1, int w2, int id2){
    if (w1 != w2) return w1 < w2;
    return id1 < id2;
}

static Node* rotR(Node* t){
    Node* x = t->l;
    t->l = x->r;
    x->r = t;
    pull(t); pull(x);
    return x;
}
static Node* rotL(Node* t){
    Node* x = t->r;
    t->r = x->l;
    x->l = t;
    pull(t); pull(x);
    return x;
}

static Node* insert(Node* t, int w, int id){
    if (!t) return new Node(w, id, rng());
    if (lessKey(w, id, t->w, t->id)) {
        t->l = insert(t->l, w, id);
        if (t->l->pr > t->pr) t = rotR(t);
    } else {
        t->r = insert(t->r, w, id);
        if (t->r->pr > t->pr) t = rotL(t);
    }
    pull(t);
    return t;
}

static Node* erase(Node* t, int w, int id){
    if (!t) return t;
    if (w == t->w && id == t->id) {
        if (!t->l) {
            Node* r = t->r;
            delete t;
            return r;
        } else if (!t->r) {
            Node* l = t->l;
            delete t;
            return l;
        } else {
            if (t->l->pr > t->r->pr) {
                t = rotR(t);
                t->r = erase(t->r, w, id);
            } else {
                t = rotL(t);
                t->l = erase(t->l, w, id);
            }
        }
    } else if (lessKey(w, id, t->w, t->id)) {
        t->l = erase(t->l, w, id);
    } else {
        t->r = erase(t->r, w, id);
    }
    pull(t);
    return t;
}

static int sumLargest(Node* t, int r){
    if (!t || r <= 0) return 0;
    int sr = getsz(t->r);
    if (sr >= r) {
        return sumLargest(t->r, r);
    } else {
        int res = getsum(t->r) + t->w;
        int rem = r - sr - 1;
        return res + sumLargest(t->l, rem);
    }
}

int main() {
    int N, Q;
    if (scanf("%d %d", &N, &Q) != 2) return 0;
    std::vector<int> a(N+1), cnt(N+1, 0);
    for (int i = 1; i <= N; i++) {
        scanf("%d", &a[i]);
        cnt[a[i]]++;
    }

    int S = 0;
    for (int i = 1; i <= N; i++) S += a[i];

    Node* root = nullptr;
    for (int v = 1; v <= N; v++) {
        if (cnt[v] > 0) {
            root = insert(root, v * cnt[v], v);
        }
    }

    for (int qi = 0; qi < Q; qi++) {
        int t;
        scanf("%d", &t);
        if (t == 1) {
            int k; scanf("%d", &k);
            int plays = N - k;
            int classes = getsz(root);
            int r = (plays < classes ? plays : classes);
            int take = sumLargest(root, r);
            int ans = S - take;
            printf("%d\n", ans);
        } else {
            int x, y; scanf("%d %d", &x, &y);
            if (a[x] == y) continue;
            int vold = a[x], vnew = y;

            int w_old = vold * cnt[vold];
            root = erase(root, w_old, vold);
            cnt[vold]--;
            if (cnt[vold] > 0) {
                root = insert(root, vold * cnt[vold], vold);
            }

            int w_new = vnew * cnt[vnew];
            if (cnt[vnew] > 0) {
                root = erase(root, w_new, vnew);
            }
            cnt[vnew]++;
            root = insert(root, vnew * cnt[vnew], vnew);

            S += y - vold;
            a[x] = y;
        }
    }
    return 0;
}